guidance_prompt = """
### Guidance: 
    First generate abstract sequence, further convert into waypoints"""

action_prompt = """
### Actions for execution:
    [MOVE_X] target_x (grab)
    [MOVE_Y] target_y (grab)
    [MOVE_Z] target_z (grab)
    [GRIP] 
    [PUSH] target_x target_y target_z (grab)
    [PULL] target_x target_y target_z (grab)"""


####################################################################################################

puck_drawer_button_stick_demo_prompt = [
    f"""
### Task Instruction: 
    Slide Puck to Goal and Close Drawer and Press Button and Insert Peg to Goal

### Object Kinematic Knowledge:
    <hand pos="-0.000 0.500 0.200"/>
    <puck>
        <puck pos="0.200 0.490 0.045" type="box" size="0.05 0.05 0.015" mass=".05"/>
        <goal pos="0.370 0.500 0.020"/>
    </puck>
    <drawer>
        <joint pos="0.200 0.890 0.090" type="slide" axis="0 1 0" range="-0.16 0"/>
        <handle pos="0.200 0.750 0.090"/>
    </drawer>
    <button>
        <joint pos="-0.120 0.949 0.115" type="slide" axis="0 -1 0" stiffness="0.5" range="-0.06 0" damping="1"/>
        <button pos="-0.120 0.756 0.115"/>
    </button>
    <peg>
        <peg pos="-0.170 0.600 0.025" type="box" euler="0 1.57 0" size="0.015 0.015 0.12"/>
        <goal pos="-0.570 0.600 0.160"/>
    </peg>

{guidance_prompt}

{action_prompt}

### Abstract Manipulation Sequence:
    1. Align with puck's x position (0.200)
    2. Move right little bit (0.100)
    3. Align with puck's y position (0.500)
    4. Descend hand to place grippers right of puck (0.045)
    5. Now push the puck toward goal position (0.370, 0.500, 0.045)

    6. Align back to handle's x position (0.002)
    7. Align back to handle's y position (0.496)
    8. Align back to handle's z position (0.200)

    9. Align with drawer handle's z position (0.090)
    10. Move up little bit (0.130)
    11. Align with drawer handle's x position (0.200)
    12. Align with drawer handle's y position (0.750)
    13. Now push the drawer handle toward front direction to close the drawer (0.200, 0.800, 0.130)

    22. Align back to handle's y position (0.496)
    23. Align back to handle's x position (0.002)
    24. Align back to handle's z position (0.200)

    17. Align with button's x position (-0.120)
    18. Align with button's z position (0.115)
    19. Move up little bit (0.130)
    20. Approach button's y position (0.756)
    21. Now push the button toward front direction (-0.120, 0.800, 0.130)

    22. Align back to handle's y position (0.496)
    23. Align back to handle's x position (0.002)
    24. Align back to handle's z position (0.200)

    25. Align with peg's y position (0.600)
    26. Align with peg's x position (-0.170)
    27. Descend hand to 0.45 place peg between grippers, do not descend too much to z position of peg (0.045)
    28. Grip the object
    29. Align with goal's z position while grabbing (0.130 grab)
    30. Align with goal's y position while grabbing (0.600 grab)
    31. Move object toward goal position in x axis while grabbing  (-0.570 grab)

    
### 3D Manipulation Waypoints:
    [MOVE_X] 0.200
    [MOVE_X] 0.130
    [MOVE_Y] 0.500
    [MOVE_Z] 0.045
    [PUSH] 0.370 0.500 0.045

    [MOVE_X] 0.002
    [MOVE_Y] 0.496
    [MOVE_Z] 0.200
    
    [MOVE_Z] 0.090
    [MOVE_Z] 0.130
    [MOVE_X] 0.200
    [MOVE_Y] 0.750
    [PUSH] 0.200 0.800 0.130

    [MOVE_Y] 0.496
    [MOVE_X] 0.002
    [MOVE_Z] 0.200

    [MOVE_X] -0.120
    [MOVE_Z] 0.115
    [MOVE_Z] 0.130
    [MOVE_Y] 0.756
    [PUSH] -0.120 0.800 0.130

    [MOVE_Y] 0.496
    [MOVE_X] 0.002
    [MOVE_Z] 0.200

    [MOVE_Y] 0.600
    [MOVE_X] -0.170
    [MOVE_Z] 0.045
    [GRIP]
    [MOVE_Z] 0.130 grab
    [MOVE_Y] 0.600 grab
    [MOVE_X] -0.570 grab
""",
]
